function yinterp = ntrp89split(tinterp,t,y,h,f1,f8,f9,f10,f11,f12,f13,f14,f15,f17,f18,f19,f20,f21,idxNonNegative)
%NTRP89SPLIT  Interpolation helper function for ODE89.
%   YINTERP = NTRP89SPLIT(TINTERP,T,Y,TNEW,YNEW,H,F,IDX) uses data computed
%   in ODE89 to approximate the solution at time TINTERP. TINTERP may be a
%   scalar or a row vector. The arguments TNEW and YNEW do not affect the
%   computations. They are required for consistency of syntax with other
%   interpolation functions. Any values entered for TNEW and YNEW are
%   ignored.
%
%   IDX has indices of solution components that must be non-negative.
%   Negative YINTERP(IDX) are replaced with zeros and the derivative
%   YPINTERP(IDX) is set to zero.
%
%   See also ODE89, DEVAL.

%   Copyright 1984-2023 The MathWorks, Inc.

% Define the columns of coefficients of the 8th-order continuous extension
% of the Verner 9(8) "most robust" pair. The weights are formed as
% BI8*theta^8 + BI7*theta^7 + ... + BI2*theta^2 + BI1*theta, where
% theta = (tinterp - t)/h. Since stages 2, 3, 4, 5, 6, 7, and 16 are not
% used, these rows in the the full coefficient matrix are zero. They are
% omitted here and the other rows shifted up. BI1 is not defined explicitly
% because it is [1;0;0;...;0].

BI2 = [-12.75304069282388950483064356409920964903;
       -.7205785602508598770412906345635211707530;
       -48.06969107148755163304089843112677204750;
        16.32345788425353372538518290168630386345;
       -5.888504109270884968456670963647316074790;
       -69.22821100686856642029708151339949374410;
       -38.04668072585188932845088326881300565231;
       -75.21598899610186748511604166683735788867;
       -19.46588639117053206710108537195779499764;
        22.25276964616901764060657108171977843291;
        14.38227638804283974976194859491865842966;
        94.92756297288050252130347529152607755873;
        63.97757128518312942674385099931772857860;
        57.52494337729701822053356654527592436144];

BI3 = [ 68.54470113831162103032818060021729044674;
        6.559119452090996226782640921071801708575;
        451.8280048138745279924509263176669733181;
       -118.7000544943430560099961188668917723161;
        89.44704113715942232261735606938508401319;
        627.4402883568152894700875088172124339413;
        340.9894379782233715580222226199659613703;
        670.5551756563966247587443735545005782764;
        172.8442419404515527792492527636420780662;
       -202.2239493340537483960420170974810960961;
       -301.8862921284913174289877784920239768093;
       -819.3810521264963242304829331408227079441;
       -398.4710369466142415586467341825347335632;
       -587.5456254433247185141268798839079144120];

BI4 = [-194.8086610529652454702496599846926584629;
       -23.65417183348355244612060745867113623926;
       -1652.497181212881040972312045847339995538;
        379.7566858308294928207030358265089540700;
       -380.5212519133325379643523316755978956588;
       -2258.351433966898561277167615407280413114;
       -1221.089637320158271327850635113537223709;
       -2395.425253052829223230171636642290078449;
       -616.3040486605512589130986770456245791880;
        741.1380586926791133828821084525361362850;
        1781.158815560130838385479471257488378388;
        2811.287710727701073955763185548552769132;
        716.5966869905804904541294272473572154569;
        2312.713681211178682602365980842590527027];

BI5 = [ 317.7392440058917273091720330437842255568;
        44.16895609281556502164197054695369477469;
        3109.740640759030910750811309301753788556;
       -658.7110535057816543655898314260197627370;
        770.9937272473377188110779497353201847420;
        4212.395800215491820633428188331388768232;
        2271.121533555259071203608357605468537656;
        4449.143231627101738352915330060972953361;
        1143.483637444009748019174885933341490497;
       -1419.345991543901288934527221623894382397;
       -4706.785555404445608825447884178551282728;
       -4973.994583541372152306531194715881127387;
        52.89052166461839778508215175982407959882;
       -4612.840108616055993454816044374461167725];

BI6 = [-299.5110317016553611442365899609354277447;
       -45.39036357573745767095716350329312304563;
       -3211.322751886536222454319056864879758831;
        644.2805206048469902599556429935393520064;
       -831.4716893548379599332950159082545018560;
       -4325.916149192490627782429268979382924699;
       -2328.099120585713191256845645730711618239;
       -4556.769050179329341174034103718438911683;
       -1170.357669638643781845251579162353094100;
        1505.723453115174938364140876028053730124;
        6291.645831877559252216657958850293660213;
        4810.867980444981597632278117658725359609;
       -1470.500844962700814722191656818947551329;
        4986.820885035081979510527485116584809575];

BI7 = [ 151.9504248851541972968268022793780785647;
        24.43461389111572285100991773589739045465;
        1734.432866374712319698880133120955280438;
       -334.8751825767893992539894957157903467478;
        461.9387177871916189774255799856083869291;
        2327.648261456242912420669452255092833474;
        1251.132631830924456968695609885535799254;
        2447.365350086656490540478347199404246857;
        628.2905498131297391288540900112436704439;
       -841.3580375761078273196578619974820483141;
       -4164.432457468105482852522949304279052327;
       -2417.563170381452428143421579409061339218;
        1524.433133991196905505389714285761298379;
       -2793.397702113869225818637760332264198189];

BI8 = [-32.14704772912899411981910701782974118232;
       -5.395551268662524772664900940711910826177;
       -383.8940830682559717177907419834455933213;
        72.05311579106953179281845208383275272780;
       -104.2735790197010640588910140881002072916;
       -513.8098304131662767347811744202515986459;
       -275.9322212851025822454499429637433189491;
       -539.5239805539746656111293686438409662456;
       -138.4613470596128476846868080169758635556;
        193.8136970000397952625975451565478819654;
        1085.917381175309478755059233272153614833;
        493.8555519037577305710909287669609682492;
       -488.9260320222638668905067532907780371207;
        636.7239265496922574541536520861820193631];

yinterp = zeros(size(y,1), size(tinterp,2), 'like', y);
for k = 1:numel(tinterp)
    yinterp(:,k) = y + h*yinterpWSS((tinterp(k) - t)/h, ...
        BI2,BI3,BI4,BI5,BI6,BI7,BI8, ...
        f1,f8,f9,f10,f11,f12,f13,f14,f15,f17,f18,f19,f20,f21);
end

% Non-negative solution
if ~isempty(idxNonNegative)
    for k = idxNonNegative
        yinterp(k,:) = max(yinterp(k,:),0);
    end
end

%--------------------------------------------------------------------------

function sp = yinterpWSS(theta, ...
    BI2,BI3,BI4,BI5,BI6,BI7,BI8, ...
    f1,f8,f9,f10,f11,f12,f13,f14,f15,f17,f18,f19,f20,f21)
% Weighted sum of stages used to compute yinterp for
% theta = (tinterp - t)/h.
b = BI8;
b = b*theta + BI7;
b = b*theta + BI6;
b = b*theta + BI5;
b = b*theta + BI4;
b = b*theta + BI3;
b = b*theta + BI2;
% BI1 = [1;0;...;0] so we perform the last step
%     b = (b*theta + BI1)*theta;
% in slightly different fashion.
b = b*(theta*theta);
b(1) = b(1) + theta;
sp = b(1)*f1 + ...
    b(2)*f8 + ...
    b(3)*f9 + ...
    b(4)*f10 + ...
    b(5)*f11 + ...
    b(6)*f12 + ...
    b(7)*f13 + ...
    b(8)*f14 + ...
    b(9)*f15 + ...
    b(10)*f17 + ...
    b(11)*f18 + ...
    b(12)*f19 + ...
    b(13)*f20 + ...
    b(14)*f21;

%--------------------------------------------------------------------------
